/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.system;

import com.ibm.hwmca.base.util.BaseFileControl;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.HwmcaParser;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkEventText;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.log.FrameworkLogAttributes;
import com.ibm.hwmca.fw.log.SystemEventLog;
import com.ibm.hwmca.fw.managed.ManagedObjectManager;
import com.ibm.hwmca.fw.managed.Tower;
import com.ibm.hwmca.fw.system.CommonSystem;
import com.ibm.hwmca.fw.system.IniFileProcessor;
import com.ibm.hwmca.fw.task.UserContext;
import com.ibm.hwmca.fw.util.HThreadGroup;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.fw.util.UUIDFactory;
import java.awt.Toolkit;
import java.io.File;
import java.io.FileInputStream;
import java.lang.reflect.Constructor;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Manager
implements Runnable {
    private static final short GENERAL_ERR = 2000;
    private static final short INIT_ERR = 2001;
    private static final short TERM_ERR = 2002;
    private static final short STATIC_INIT_ERR = 2003;
    private static final short TOWER_WEIGHT_ERR = 2004;
    private static final short TOWER_FILE_NAME_ERR = 2005;
    private static final short MOM_ADD_ERR = 2006;
    private static final short TOWER_CREATE_ERR = 2007;
    private static final short TOWER_STARTUP_ERR = 2008;
    private static final short TOWER_SHUTDOWN_ERR = 2009;
    private static final short TOWER_FILE_ERR = 2010;
    private static final String START_INI_FILE_NAME = "mgrstart.ini";
    private static final String STOP_INI_FILE_NAME = "mgrstop.ini";
    private static final String PLUGINS_PATH = "plugins";
    private static final short STARTUP_DONE = 2011;
    private static FrameworkClassLogInfo logInfo;
    private static final String TRACE_MASKT = "XMGRMGRT";
    private static final String TRACE_MASKF = "XMGRMGRF";
    private static final String TRACE_MASKD = "XMGRMGRD";
    private static Manager manager;
    private ArrayList towers = new ArrayList();
    private ArrayList preInit = new ArrayList();
    private ArrayList postInit = new ArrayList();
    private boolean preInitDone = false;
    private boolean towersStarted = false;
    private boolean readyForClientStartup;
    private boolean managerStartupSucceeded;
    static /* synthetic */ Class class$java$lang$String;

    private Manager() {
        Trace.trace(TRACE_MASKT, "<> Manager");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        block29: {
            Manager manager;
            Trace.trace(TRACE_MASKT, "-> Manager.run()");
            try {
                try {
                    Manager manager2;
                    String performInit;
                    this.managerStartupSucceeded = false;
                    CommonSystem.getCommonSystem().setSystemUserContext(new UserContext(null, InetAddress.getByName("127.0.0.1"), 3, UUIDFactory.generate(4), Locale.getDefault()));
                    try {
                        BaseFileControl.makeFilePath("domainsocket");
                    }
                    catch (Exception exc) {
                        Trace.trace(TRACE_MASKF, "Exception occurred creating temporary HMC directory");
                        Trace.trace(TRACE_MASKF, exc);
                    }
                    IniFileProcessor.runClasses(START_INI_FILE_NAME, "Manager INI");
                    this.discoverTowers();
                    this.managerStartupSucceeded = true;
                    if (CommonSystem.getCommonSystem().isLocationUnified()) {
                        Manager exc = this;
                        synchronized (exc) {
                            this.readyForClientStartup = true;
                            this.notifyAll();
                        }
                    }
                    if ((performInit = System.getProperty("PERFORM_INIT", "YES")).equalsIgnoreCase("YES")) {
                        manager2 = this;
                        synchronized (manager2) {
                            Trace.trace(TRACE_MASKF, "Manager is waiting for preinit hooks to run...");
                            while (!this.preInitDone) {
                                try {
                                    this.wait();
                                }
                                catch (InterruptedException interruptedException) {}
                            }
                        }
                    }
                    this.launchTowers();
                    manager2 = this;
                    synchronized (manager2) {
                        this.towersStarted = true;
                        this.notifyAll();
                    }
                    ManagedObjectManager.getManagedObjectManager().dumpInventory();
                }
                catch (Exception exc) {
                    new FrameworkLog(logInfo, 2001, exc).log();
                    Object var7_8 = null;
                    if (CommonSystem.getCommonSystem().isLocationUnified()) {
                        Manager manager3 = this;
                        synchronized (manager3) {
                            if (!this.readyForClientStartup) {
                                this.readyForClientStartup = true;
                                this.notifyAll();
                            }
                        }
                    }
                    break block29;
                }
                Object var7_7 = null;
                if (!CommonSystem.getCommonSystem().isLocationUnified()) break block29;
                manager = this;
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                if (CommonSystem.getCommonSystem().isLocationUnified()) {
                    Manager manager4 = this;
                    synchronized (manager4) {
                        if (!this.readyForClientStartup) {
                            this.readyForClientStartup = true;
                            this.notifyAll();
                        }
                    }
                }
                throw throwable;
            }
            synchronized (manager) {
                if (!this.readyForClientStartup) {
                    this.readyForClientStartup = true;
                    this.notifyAll();
                }
            }
        }
        Trace.trace(TRACE_MASKF, "Manager is ready for clients");
        new FrameworkLog(logInfo, 2011).log(FrameworkLogAttributes.INFO_LOG);
        new SystemEventLog(new FrameworkEventText(51), "SPINIT").log();
        if (!CommonSystem.getCommonSystem().isLocationUnified()) {
            try {
                Toolkit.getDefaultToolkit().beep();
            }
            catch (InternalError internalError) {
                // empty catch block
            }
        }
        Trace.trace(TRACE_MASKT, "<- Manager.run()");
    }

    public static Manager getManager() {
        return manager;
    }

    public void shutdown() {
        Trace.trace(TRACE_MASKT, "-> Manager.shutdown()");
        try {
            this.haltTowers();
        }
        catch (Exception exc) {
            new FrameworkLog(logInfo, 2002, exc).log();
        }
        Trace.trace(TRACE_MASKT, "<- Manager.shutdown()");
    }

    private List getTowers() {
        return this.towers;
    }

    private void discoverTowers() throws HException {
        Trace.trace(TRACE_MASKF, "-> Manager.discoverTowers");
        ArrayList<String> towerFiles = new ArrayList<String>();
        ArrayList<Integer> towerWeights = new ArrayList<Integer>();
        Trace.trace(TRACE_MASKF, "Searching for tower files");
        String towerPluginsPath = BaseFileControl.getFilePath(PLUGINS_PATH);
        towerPluginsPath = towerPluginsPath + "tower/";
        File directory = new File(towerPluginsPath);
        String[] fileNames = directory.list();
        for (int ix = 0; ix < fileNames.length; ++ix) {
            String towerFileName = towerPluginsPath + fileNames[ix];
            File file = new File(towerFileName);
            if (file.isDirectory()) {
                Trace.trace(TRACE_MASKF, "  Skipping directory: " + towerFileName);
                continue;
            }
            int dotIndex = fileNames[ix].indexOf(46);
            if (dotIndex != -1 && dotIndex != fileNames[ix].length()) {
                String towerWeight = fileNames[ix].substring(0, dotIndex);
                try {
                    Integer weight = new Integer(towerWeight);
                    towerFiles.add(towerFileName);
                    towerWeights.add(weight);
                    Trace.trace(TRACE_MASKF, "  Found file: " + towerFileName + " with weight " + weight);
                }
                catch (NumberFormatException exc) {
                    String s = "Error: Skipping file: " + towerFileName + " because the weight is not numeric.";
                    Trace.trace(TRACE_MASKF, "  " + s);
                    HException hexc = new HException(s);
                    new FrameworkLog(logInfo, 2004, hexc).log(FrameworkLogAttributes.INFO_LOG);
                }
                continue;
            }
            String s = "Error: Skipping file: " + towerFileName + " because the file name is invalid.";
            Trace.trace(TRACE_MASKF, "  " + s);
            HException hexc = new HException(s);
            new FrameworkLog(logInfo, 2005, hexc).log(FrameworkLogAttributes.INFO_LOG);
        }
        for (int ix1 = 0; ix1 < towerWeights.size() - 1; ++ix1) {
            for (int ix2 = ix1 + 1; ix2 < towerWeights.size(); ++ix2) {
                Integer weight1 = (Integer)towerWeights.get(ix1);
                Integer weight2 = (Integer)towerWeights.get(ix2);
                if (weight1 <= weight2) continue;
                String towerFile = (String)towerFiles.get(ix1);
                towerFiles.set(ix1, (String)towerFiles.get(ix2));
                towerFiles.set(ix2, towerFile);
                towerWeights.set(ix2, weight1);
                towerWeights.set(ix1, weight2);
            }
        }
        this.processTowerFiles(towerFiles);
        Trace.trace(TRACE_MASKF, "<- Manager.discoverTowers");
    }

    private void launchTowers() {
        Trace.trace(TRACE_MASKF, "-> Manager.launchTowers");
        Iterator iterator = this.getTowers().iterator();
        while (iterator.hasNext()) {
            Tower tower = (Tower)iterator.next();
            try {
                Trace.trace(TRACE_MASKF, "Launching tower " + tower.getName());
                tower.startTower();
            }
            catch (Exception exc) {
                Trace.trace(TRACE_MASKF, "Manager.launchTowers() caught exception processing tower " + tower.getName());
                new FrameworkLog(logInfo, 2008, exc).log(FrameworkLogAttributes.INFO_LOG);
                iterator.remove();
                ManagedObjectManager.getManagedObjectManager().remove(tower.getObjectId());
            }
        }
        Trace.trace(TRACE_MASKF, "<- Manager.launchTowers");
    }

    private void haltTowers() {
        Trace.trace(TRACE_MASKF, "-> Manager.haltTowers");
        if (this.towersStarted) {
            for (int i = this.getTowers().size() - 1; i <= 0; --i) {
                Tower tower = (Tower)this.getTowers().get(i);
                try {
                    Trace.trace(TRACE_MASKF, "Halting tower " + tower.getName());
                    tower.stopTower();
                    continue;
                }
                catch (Exception exc) {
                    Trace.trace(TRACE_MASKF, "Manager.haltTowers() caught exception processing tower " + tower.getName());
                    new FrameworkLog(logInfo, 2009, exc).log(FrameworkLogAttributes.INFO_LOG);
                }
            }
        }
        Trace.trace(TRACE_MASKF, "<- Manager.haltTowers");
    }

    private void processTowerFiles(List towerFiles) {
        ManagedObjectManager mom = ManagedObjectManager.getManagedObjectManager();
        ArrayList<String> towerClasses = new ArrayList<String>();
        ArrayList<String> towerXMLNames = new ArrayList<String>();
        Iterator iterator = towerFiles.iterator();
        while (iterator.hasNext()) {
            File file = new File((String)iterator.next());
            try {
                Trace.trace(TRACE_MASKF, "Working on tower file [" + file.getName() + "]");
                FileInputStream fis = new FileInputStream(file);
                Document doc = new HwmcaParser(fis, false).getDocument();
                NodeList nodes = doc.getElementsByTagName("tower");
                for (int i = 0; i < nodes.getLength(); ++i) {
                    Node node = nodes.item(i);
                    if (node.getNodeType() != 1) continue;
                    String towerClassName = null;
                    NodeList childNodes = node.getChildNodes();
                    for (int k = 0; k < childNodes.getLength(); ++k) {
                        Node childNode = childNodes.item(k);
                        String name = childNode.getNodeName().toLowerCase();
                        if (name == null) continue;
                        if (name.equals("class")) {
                            towerClassName = HwmcaParser.getValue(childNode);
                            continue;
                        }
                        if (name.equals("preinit")) {
                            this.preInit.add(HwmcaParser.getValue(childNode));
                            continue;
                        }
                        if (!name.equals("postinit")) continue;
                        this.postInit.add(HwmcaParser.getValue(childNode));
                    }
                    if (towerClassName == null) continue;
                    Trace.trace(TRACE_MASKF, "Tower object class name is [" + towerClassName + "]");
                    towerClasses.add(towerClassName);
                    towerXMLNames.add(file.getName());
                }
            }
            catch (Exception exc) {
                Trace.trace(TRACE_MASKF, "Error processing file name [" + file.getName() + "]");
                new FrameworkLog(logInfo, 2010, exc).log();
            }
        }
        Tower tower = null;
        int size = towerClasses.size();
        for (int i = 0; i < size; ++i) {
            String className;
            String towerName = className = (String)towerClasses.get(i);
            try {
                int dotIndex = className.lastIndexOf(".");
                if (dotIndex != -1) {
                    towerName = className.substring(dotIndex + 1);
                }
                Class<?> towerClass = Class.forName(className);
                Class[] argTypes = new Class[]{class$java$lang$String == null ? Manager.class$("java.lang.String") : class$java$lang$String};
                Constructor<?> towerConstructor = towerClass.getConstructor(argTypes);
                Object[] args = new Object[]{towerName};
                tower = (Tower)towerConstructor.newInstance(args);
                try {
                    mom.add(tower);
                    tower.setXMLFile((String)towerXMLNames.get(i));
                    this.getTowers().add(tower);
                }
                catch (Exception exc) {
                    Trace.trace(TRACE_MASKF, "Error trying to add tower to MOM [" + className + "]");
                    new FrameworkLog(logInfo, 2006, exc).log();
                }
                Trace.trace(TRACE_MASKF, "Tower is [" + tower + "]");
                continue;
            }
            catch (Throwable exc) {
                Trace.trace(TRACE_MASKF, "Error creating tower [" + className + "]");
                new FrameworkLog(logInfo, 2007, exc).log();
            }
        }
    }

    List getTowerPreInitializationClassNames() {
        return (List)this.preInit.clone();
    }

    List getTowerPostInitializationClassNames() {
        return (List)this.postInit.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setPreInitDone(boolean preInitDone) {
        Trace.trace(TRACE_MASKF, "<> Manager.setPreInitDone " + preInitDone);
        Manager manager = this;
        synchronized (manager) {
            this.preInitDone = preInitDone;
            this.preInit.clear();
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForTowers() {
        Trace.trace(TRACE_MASKF, "<> Manager.waitForTowers");
        Manager manager = this;
        synchronized (manager) {
            Trace.trace(TRACE_MASKF, "waiting for towers to start...");
            while (!this.towersStarted) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public synchronized void waitUntilSafeForClient() {
        while (!this.readyForClientStartup) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public boolean managerStartupSucceeded() {
        return this.managerStartupSucceeded;
    }

    public static void main(String[] args) {
        try {
            CommonSystem system = CommonSystem.getCommonSystem();
            for (int i = 0; i < args.length; ++i) {
                String parm = args[i];
                if ((parm = parm.toLowerCase()).equals("cim=true") || parm.equals("cim=on") || parm.equals("cim=1") || parm.equals("cim=yes")) {
                    system.setCimom(true);
                    continue;
                }
                if (!parm.equals("cim=false") && !parm.equals("cim=off") && !parm.equals("cim=0") && !parm.equals("cim=no")) continue;
                system.setCimom(false);
            }
            Trace.trace(TRACE_MASKF, "Starting the manager");
            manager = new Manager();
            HThreadGroup.defaultThreadGroup().createThread(manager, "ManagerMain").start();
        }
        catch (Throwable thrown) {
            new FrameworkLog(logInfo, 2000, thrown).log();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            Trace.setDefaultOutput("manager.out");
            CommonSystem.getCommonSystem().setLocation(1);
            if (System.getProperty("HMC_USING_HTML") != null) {
                CommonSystem.getCommonSystem().setUsingHTML(true);
            }
            logInfo = new FrameworkClassLogInfo(85, "Manager");
        }
        catch (Throwable thrown) {
            CommonSystem.getCommonSystem().setLocation(1);
            logInfo = new FrameworkClassLogInfo(85, "Manager");
            new FrameworkLog(logInfo, 2003, thrown).log();
        }
    }
}

